using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;

class Program
{
    struct Point
    {
        public double X;
        public double Y;
        public int Id;
    }

    static double Manhattan(Point a, Point b)
    {
        return Math.Abs(a.X - b.X) + Math.Abs(a.Y - b.Y);
    }

    static void Main()
    {
        CultureInfo.CurrentCulture = CultureInfo.InvariantCulture;
        var first = Console.ReadLine();
        if (string.IsNullOrWhiteSpace(first)) return;
        var parts = first.Trim().Split(new[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);
        int n = int.Parse(parts[0]);
        double eps = double.Parse(parts[1], CultureInfo.InvariantCulture);
        var pts = new List<Point>(n);
        for (int i = 0; i < n; i++)
        {
            var line = Console.ReadLine();
            while (string.IsNullOrWhiteSpace(line)) line = Console.ReadLine();
            var p = line.Trim().Split(new[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);
            double x = double.Parse(p[0], CultureInfo.InvariantCulture);
            double y = double.Parse(p[1], CultureInfo.InvariantCulture);
            pts.Add(new Point { X = x, Y = y, Id = i + 1 });
        }
        int kmax = Math.Max(1, (int)Math.Floor(1.0 / eps));
        var order = pts.Select((p, idx) => new { P = p, idx })
                       .OrderBy(t => t.P.X)
                       .ThenBy(t => t.P.Y)
                       .Select(t => t.idx)
                       .ToArray();
        var covered = new bool[n];
        var selectedIndices = new List<int>();
        for (int oi = 0; oi < order.Length && selectedIndices.Count < kmax; oi++)
        {
            int i = order[oi];
            if (covered[i]) continue;
            selectedIndices.Add(i);
            var center = pts[i];
            for (int j = 0; j < n; j++)
            {
                if (!covered[j])
                {
                    double d = Math.Abs(center.X - pts[j].X) + Math.Abs(center.Y - pts[j].Y);
                    if (d <= eps + 1e-12) covered[j] = true;
                }
            }
        }
        if (selectedIndices.Count == 0) selectedIndices.Add(0);
        int k = selectedIndices.Count;
        var edges = new List<(int aIdx, int bIdx)>();
        if (k >= 2)
        {
            var inMST = new bool[k];
            var minDist = new double[k];
            var parent = new int[k];
            for (int i = 0; i < k; i++) { minDist[i] = double.PositiveInfinity; parent[i] = -1; }
            minDist[0] = 0.0;
            for (int iter = 0; iter < k; iter++)
            {
                int u = -1;
                double best = double.PositiveInfinity;
                for (int i = 0; i < k; i++)
                {
                    if (!inMST[i] && minDist[i] < best)
                    {
                        best = minDist[i];
                        u = i;
                    }
                }
                if (u == -1) break;
                inMST[u] = true;
                if (parent[u] != -1) edges.Add((parent[u], u));
                for (int v = 0; v < k; v++)
                {
                    if (inMST[v]) continue;
                    double d = Manhattan(pts[selectedIndices[u]], pts[selectedIndices[v]]);
                    if (d < minDist[v])
                    {
                        minDist[v] = d;
                        parent[v] = u;
                    }
                }
            }
        }
        Console.WriteLine(k);
        Console.WriteLine(string.Join(" ", selectedIndices.Select(idx => pts[idx].Id)));
        foreach (var e in edges)
        {
            int aOrig = pts[selectedIndices[e.aIdx]].Id;
            int bOrig = pts[selectedIndices[e.bIdx]].Id;
            Console.WriteLine($"{aOrig} {bOrig}");
        }
    }
}